/**
 * Javascript to enhance the paged content paging bar.
 *
 * @module     core/paging_bar
 * @copyright  2018 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core/paged_content_paging_bar",["jquery","core/custom_interaction_events","core/paged_content_events","core/str","core/pubsub","core/pending"],(function($,CustomEvents,PagedContentEvents,Str,PubSub,Pending){var SELECTORS_PAGE="[data-page]",SELECTORS_PAGE_ITEM='[data-region="page-item"]',SELECTORS_PAGE_LINK='[data-region="page-link"]',SELECTORS_FIRST_BUTTON='[data-control="first"]',SELECTORS_LAST_BUTTON='[data-control="last"]',SELECTORS_NEXT_BUTTON='[data-control="next"]',SELECTORS_PREVIOUS_BUTTON='[data-control="previous"]',SELECTORS_DOTS_BUTTONS="[data-dots]",SELECTORS_BEGINNING_DOTS_BUTTON='[data-dots="beginning"]',SELECTORS_ENDING_DOTS_BUTTON='[data-dots="ending"]',getPageByNumber=function(root,pageNumber){return root.find(SELECTORS_PAGE_ITEM+'[data-page-number="'+pageNumber+'"]')},setLastPageNumber=function(root,number){root.attr("data-last-page-number",number)},getLastPageNumber=function(root){return parseInt(root.attr("data-last-page-number"),10)},getActivePageNumber=function(root){return parseInt(root.attr("data-active-page-number"),10)},setActivePageNumber=function(root,number){root.attr("data-active-page-number",number)},getPageNumber=function(root,page){if(null!=page.attr("data-page"))return parseInt(page.attr("data-page-number"),10);var pageNumber=1,activePageNumber=null;switch(page.attr("data-control")){case"first":default:pageNumber=1;break;case"last":pageNumber=getLastPageNumber(root);break;case"next":activePageNumber=getActivePageNumber(root);var lastPage=getLastPageNumber(root);pageNumber=lastPage?activePageNumber&&activePageNumber<lastPage?activePageNumber+1:lastPage:activePageNumber+1;break;case"previous":pageNumber=(activePageNumber=getActivePageNumber(root))&&activePageNumber>1?activePageNumber-1:1}return parseInt(pageNumber,10)},show=function(root){root.removeClass("hidden")},hide=function(root){root.addClass("hidden")},disableNextControlButtons=function(root){var nextButton=root.find(SELECTORS_NEXT_BUTTON),lastButton=root.find(SELECTORS_LAST_BUTTON);nextButton.addClass("disabled"),nextButton.attr("aria-disabled",!0),lastButton.addClass("disabled"),lastButton.attr("aria-disabled",!0)},enableNextControlButtons=function(root){var nextButton=root.find(SELECTORS_NEXT_BUTTON),lastButton=root.find(SELECTORS_LAST_BUTTON);nextButton.removeClass("disabled"),nextButton.removeAttr("aria-disabled"),lastButton.removeClass("disabled"),lastButton.removeAttr("aria-disabled")},disablePreviousControlButtons=function(root){var previousButton=root.find(SELECTORS_PREVIOUS_BUTTON),firstButton=root.find(SELECTORS_FIRST_BUTTON);previousButton.addClass("disabled"),previousButton.attr("aria-disabled",!0),firstButton.addClass("disabled"),firstButton.attr("aria-disabled",!0)},adjustPagingBarSize=function(root){var activePageNumber=getActivePageNumber(root),lastPageNumber=getLastPageNumber(root),dotsButtons=root.find(SELECTORS_DOTS_BUTTONS),beginningDotsButton=root.find(SELECTORS_BEGINNING_DOTS_BUTTON),endingDotsButton=root.find(SELECTORS_ENDING_DOTS_BUTTON),pages=root.find(SELECTORS_PAGE),barSize=parseInt(root.attr("data-bar-size"),10);if(barSize&&lastPageNumber>barSize){var minpage=Math.max(activePageNumber-Math.round(barSize/2),1),maxpage=minpage+barSize-1;maxpage>=lastPageNumber&&(minpage=(maxpage=lastPageNumber)-barSize+1),minpage>1?(show(beginningDotsButton),minpage++):hide(beginningDotsButton),maxpage<lastPageNumber?(show(endingDotsButton),maxpage--):hide(endingDotsButton),dotsButtons.addClass("disabled"),dotsButtons.attr("aria-disabled",!0),hide(pages),pages.each((function(index,page){page=$(page),index+1>=minpage&&index+1<=maxpage&&show(page)}))}else hide(dotsButtons)},enablePreviousControlButtons=function(root){var previousButton=root.find(SELECTORS_PREVIOUS_BUTTON),firstButton=root.find(SELECTORS_FIRST_BUTTON);previousButton.removeClass("disabled"),previousButton.removeAttr("aria-disabled"),firstButton.removeClass("disabled"),firstButton.removeAttr("aria-disabled")},showPage=function(root,pageNumber,id){var pendingPromise=new Pending("core/paged_content_paging_bar:showPage"),lastPageNumber=getLastPageNumber(root),isSamePage=pageNumber==getActivePageNumber(root),limit=function(root){return parseInt(root.attr("data-items-per-page"),10)}(root),offset=(pageNumber-1)*limit;if(!isSamePage){root.find(SELECTORS_PAGE_ITEM).removeClass("active").removeAttr("aria-current");var page=getPageByNumber(root,pageNumber);page.addClass("active"),page.attr("aria-current",!0),setActivePageNumber(root,pageNumber),adjustPagingBarSize(root)}lastPageNumber&&pageNumber>=lastPageNumber?disableNextControlButtons(root):enableNextControlButtons(root),pageNumber>1?enablePreviousControlButtons(root):disablePreviousControlButtons(root),function(root){var pageAriaLabelComponents=function(root){return root.attr("data-aria-label-components-pagination-item").split(",").map((function(component){return component.trim()}))}(root),activePageAriaLabelComponents=function(root){return root.attr("data-aria-label-components-pagination-active-item").split(",").map((function(component){return component.trim()}))}(root),activePageNumber=getActivePageNumber(root),pageItems=root.find(SELECTORS_PAGE_ITEM),stringRequests=pageItems.map((function(index,page){page=$(page);var pageNumber=getPageNumber(root,page);return pageNumber===activePageNumber?{key:activePageAriaLabelComponents[0],component:activePageAriaLabelComponents[1],param:pageNumber}:{key:pageAriaLabelComponents[0],component:pageAriaLabelComponents[1],param:pageNumber}}));Str.get_strings(stringRequests).then((function(strings){return pageItems.each((function(index,page){page=$(page);var string=strings[index];page.attr("aria-label",string),page.find(SELECTORS_PAGE_LINK).attr("aria-label",string)})),strings})).catch((function(){}))}(root),PubSub.publish(id+PagedContentEvents.SHOW_PAGES,[{pageNumber:pageNumber,limit:limit,offset:offset}]),pendingPromise.resolve()};return{init:function(root,id){var pages=(root=$(root)).find(SELECTORS_PAGE);if(function(root,items){var lastPageNumber=0;setActivePageNumber(root,0),items.each((function(index,item){var pageNumber=index+1;(item=$(item)).attr("data-page-number",pageNumber),lastPageNumber++,item.hasClass("active")&&setActivePageNumber(root,pageNumber)})),setLastPageNumber(root,lastPageNumber)}(root,pages),function(root,id){var ignoreControlWhileLoading=root.attr("data-ignore-control-while-loading"),loading=!1;""==ignoreControlWhileLoading&&(ignoreControlWhileLoading=!0),CustomEvents.define(root,[CustomEvents.events.activate]),root.on(CustomEvents.events.activate,SELECTORS_PAGE_ITEM,(function(e,data){if(data.originalEvent.preventDefault(),data.originalEvent.stopPropagation(),!ignoreControlWhileLoading||!loading){var page=$(e.target).closest(SELECTORS_PAGE_ITEM);if(!page.hasClass("disabled")){var pageNumber=getPageNumber(root,page);showPage(root,pageNumber,id),loading=!0}}})),PubSub.subscribe(id+PagedContentEvents.ALL_ITEMS_LOADED,(function(pageNumber){loading=!1;var currentLastPage=getLastPageNumber(root);(!currentLastPage||pageNumber<currentLastPage)&&setLastPageNumber(root,pageNumber),1===pageNumber&&root.attr("data-hide-control-on-single-page")?(hide(root),disableNextControlButtons(root),disablePreviousControlButtons(root)):(show(root),disableNextControlButtons(root))})),PubSub.subscribe(id+PagedContentEvents.PAGES_SHOWN,(function(){loading=!1})),PubSub.subscribe(id+PagedContentEvents.SET_ITEMS_PER_PAGE_LIMIT,(function(limit){!function(root,limit){root.attr("data-items-per-page",limit)}(root,limit),setLastPageNumber(root,0),setActivePageNumber(root,0),show(root),showPage(root,1,id)}))}(root,id),function(root){var number=getActivePageNumber(root);return!isNaN(number)&&0!=number}(root)){var activePageNumber=getActivePageNumber(root);getPageByNumber(root,activePageNumber).click(),1==activePageNumber&&disablePreviousControlButtons(root)}else(function(root){return root.find(SELECTORS_NEXT_BUTTON)})(root).click();adjustPagingBarSize(root)},disableNextControlButtons:disableNextControlButtons,enableNextControlButtons:enableNextControlButtons,disablePreviousControlButtons:disablePreviousControlButtons,enablePreviousControlButtons:enablePreviousControlButtons,showPage:showPage,rootSelector:'[data-region="paging-bar"]'}}));

//# sourceMappingURL=paged_content_paging_bar.min.js.map